﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Platform.Uri
{
    public interface INetUriParameterCollection
    {
        /// <summary>
        /// Gets a parameter value
        /// </summary>
        /// <param name="name"></param>
        /// <returns></returns>
        string this[string name] { get; set; }

        /// <summary>
        /// Gets a parameter value or a default
        /// </summary>
        /// <param name="name"></param>
        /// <param name="default"></param>
        /// <returns></returns>
        string this[string name, string @default] { get; }

        /// <summary>
        /// Gets a parameter value or a default
        /// </summary>
        /// <param name="name"></param>
        /// <param name="default"></param>
        /// <returns></returns>
        string this[string name, string @default, string @novalue] { get; }

        /// <summary>
        /// Gets all items
        /// </summary>
        IEnumerable<INetUriParameter> All { get; }        
    }
}
