﻿namespace Platform.Uri
{
    /// <summary>
    /// Authority Parameter
    /// </summary>
    public class NetUriAuthorityParameter : NetUriParameter
    {
        #region Construction

        private const string _NameSet = @"-0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_~!$&',()*+";
        private const string _ValueSet = @"-0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_~!$&',=()*+";

        public NetUriAuthorityParameter()
        {
        }

        internal NetUriAuthorityParameter(string source)
            : base( source )
        {
        }

        public NetUriAuthorityParameter(string name, string value)
            : base(name, value)
        {
        }

        #endregion

        #region properties

        protected override string NameSet
        {
            get { return _NameSet; }
        }

        protected override string ValueSet
        {
            get { return _ValueSet; }
        }

        protected override bool UseFormEncoding
        {
            get { return false; }
        }

        #endregion

        #region String Casts

        /// <summary>
        /// Convert from string
        /// </summary>
        /// <param name="source"></param>
        /// <returns></returns>
        public static implicit operator NetUriAuthorityParameter(string source)
        {
            return new NetUriAuthorityParameter(source);
        }

        /// <summary>
        /// Convert to string
        /// </summary>
        /// <param name="source"></param>
        /// <returns></returns>
        public static implicit operator string(NetUriAuthorityParameter source)
        {
            if (source == null) return null;
            else return source.ToString();
        }

        #endregion
    }
}
