﻿using Platform.Net;

namespace Platform.Uri
{
    public class NetUriAuthorityParameters : NetUriParameters<NetUriAuthorityParameter>
    {
        #region Construction & Fields

        public NetUriAuthorityParameters()
        {
        }

        internal NetUriAuthorityParameters(string source)
            : base( source )
        {
        }

        #endregion

        #region Properties

        /// <summary>
        /// Get the seperation type
        /// </summary>
        protected override NetListSeperationType Seperation { get { return NetListSeperationType.Prefixed; } }

        /// <summary>
        /// Get the seperator
        /// </summary>
        protected override char Seperator { get { return ';'; } }

        #endregion

        #region String Casts

        /// <summary>
        /// Convert from string
        /// </summary>
        /// <param name="source"></param>
        /// <returns></returns>
        public static implicit operator NetUriAuthorityParameters(string source)
        {
            return new NetUriAuthorityParameters(source);
        }

        /// <summary>
        /// Convert to string
        /// </summary>
        /// <param name="source"></param>
        /// <returns></returns>
        public static implicit operator string(NetUriAuthorityParameters source)
        {
            if (source == null) return null;
            else return source.ToString();
        }

        #endregion

        #region Encode / Decode

        protected override NetUriAuthorityParameter CreateListItem(NetStringReader reader)
        {
            return new NetUriAuthorityParameter(reader.ReadAll());
        }

        protected override NetUriAuthorityParameter CreateParameter(string name, string value)
        {
            return new NetUriAuthorityParameter(name, value);
        }

        #endregion
    }
}
