﻿
using Platform.Net;
using Platform.Extensions;

namespace Platform.Uri
{
    /// <summary>
    /// Collection of authority parameters
    /// </summary>
    public abstract class NetUriParameter : NetParameter, INetUriParameter
    {
        #region Construction & Fields

        protected NetUriParameter()
        {
        }

        protected NetUriParameter(string source)
            : base(source)
        {
        }

        protected NetUriParameter(string name, string value)
            : base(name, value)
        {
        }

        #endregion

        #region Properties

        /// <summary>
        /// Gets the name's valid character set
        /// </summary>
        protected abstract string NameSet { get; }

        /// <summary>
        /// Gets the value's valid character set
        /// </summary>
        protected abstract string ValueSet { get; }

        /// <summary>
        /// Returns true if form (plus for space) encoding should be used
        /// </summary>
        protected abstract bool UseFormEncoding { get; }

        #endregion

        #region Encoding / Decoding

        protected override string ReadName(NetStringReader reader)
        {
            return StringExtensions.UriDecode(base.ReadName(reader), UseFormEncoding);
        }

        protected override string ReadValue(NetStringReader reader)
        {
            return StringExtensions.UriDecode(base.ReadValue(reader), UseFormEncoding);
        }

        protected override void WriteName(NetStringWriter writer, string name)
        {
            base.WriteName(writer, StringExtensions.UriEncode(name, NameSet, UseFormEncoding));
        }

        protected override void WriteValue(NetStringWriter writer, string value)
        {
            base.WriteValue(writer, StringExtensions.UriEncode(value, ValueSet, UseFormEncoding));
        }

        #endregion
    }
}
