﻿using System.Linq;
using System.Collections.Generic;

using Platform.Net;

namespace Platform.Uri
{
    public abstract class NetUriParameters<T> : NetParameters<T>, INetUriParameterCollection
        where T : NetUriParameter
    {
        #region Construction & Fields

        public NetUriParameters()
        {
        }

        internal NetUriParameters(string source)
            : base( source )
        {
        }

        public IEnumerable<INetUriParameter> All
        {
            get { return this.Cast<INetUriParameter>(); }
        }

        #endregion

        protected override void OnDecode(NetStringReader reader)
        {
            Decode(reader.ReadAll());
        }
    }
}
