﻿
using Platform.Net;

namespace Platform.Uri
{
    /// <summary>
    /// Path defenition
    /// </summary>
    public class NetUriPath : NetList<NetUriPathSegment>
    {
        #region Construction & Fields

        public NetUriPath()
        {
        }

        internal NetUriPath(string source)
            : base( source )
        {
        }

        #endregion

        #region Properties

        /// <summary>
        /// Gets the seperation type
        /// </summary>
        protected override NetListSeperationType Seperation { get { return NetListSeperationType.Editable; } }

        /// <summary>
        /// Gets the seperator
        /// </summary>
        protected override char Seperator { get { return '/'; } }

        #endregion

        #region String Casts

        /// <summary>
        /// Convert from string
        /// </summary>
        /// <param name="source"></param>
        /// <returns></returns>
        public static implicit operator NetUriPath(string source)
        {
            return new NetUriPath(source);
        }

        /// <summary>
        /// Convert to string
        /// </summary>
        /// <param name="source"></param>
        /// <returns></returns>
        public static implicit operator string(NetUriPath source)
        {
            if (source == null) return null;
            else return source.ToString();
        }

        #endregion

        #region Encode / Decode

        /// <summary>
        /// Create list item
        /// </summary>
        /// <param name="source"></param>
        /// <returns></returns>
        protected override NetUriPathSegment CreateListItem( NetStringReader reader )
        {
            return new NetUriPathSegment( reader.ReadAll() );
        }

        /// <summary>
        /// decode all text from reader
        /// </summary>
        /// <param name="reader"></param>
        protected override void OnDecode( NetStringReader reader )
        {
            Decode( reader.ReadAll() );
        }

        #endregion

        #region Tools

        /// <summary>
        /// Add a relative path
        /// </summary>
        /// <param name="path"></param>
        public void AddRelativePath(string path)
        {
            if (path.StartsWith("/")) Source = path;
            else Source = ToString() + "/" + path;
        }

        #endregion
    }
}
