﻿
using Platform.Net;
using Platform.Extensions;

namespace Platform.Uri
{
    public class NetUriPathSegment : NetValue
    {
        #region Construction & Fields

        private string _Name;
        private NetUriPathSegmentParameters _Parameters;

        private const string _NameSet =  @"-0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ._~!$&',=:@()*+";

        public NetUriPathSegment()
        {
        }

        internal NetUriPathSegment( string source )
            : base( source )
        {
        }

        protected override void Initialize()
        {
            // call base class
            base.Initialize();

            // add parameters
            _Parameters = new NetUriPathSegmentParameters();
        }

        #endregion

        #region Properties

        /// <summary>
        /// Gets the name
        /// </summary>
        public string Name 
        {
            get { Decode(); return _Name; }
            set { Decode(); _Name = value; } 
        }

        /// <summary>
        /// Gets the parameters
        /// </summary>
        public NetUriPathSegmentParameters Parameters
        {
            get { Decode(); return _Parameters; }
            set { Decode(); _Parameters = value; }
        }

        #endregion

        #region String Casts

        /// <summary>
        /// Convert from string
        /// </summary>
        /// <param name="source"></param>
        /// <returns></returns>
        public static implicit operator NetUriPathSegment(string source)
        {
            return new NetUriPathSegment(source);
        }

        /// <summary>
        /// Convert to string
        /// </summary>
        /// <param name="source"></param>
        /// <returns></returns>
        public static implicit operator string(NetUriPathSegment source)
        {
            if (source == null) return null;
            else return source.ToString();
        }

        #endregion

        #region Encode & Decode

        /// <summary>
        /// Decode Path Segment
        /// </summary>
        protected override void OnDecode(NetStringReader reader)
        {
            // call base class
            base.OnDecode(reader);

            // read name
            _Name = StringExtensions.UriDecode( reader.ReadAllOrUntil(';'), false );

            // get parameters
            _Parameters = new NetUriPathSegmentParameters(reader.ReadAll());
        }

        /// <summary>
        /// Encode Path Segment
        /// </summary>
        /// <returns></returns>
        protected override void OnEncode(NetStringWriter writer)
        {
            if (_Name != null) writer.Write(_Name.UriEncode(_NameSet, false));
            if (_Parameters != null) writer.Write(_Parameters.ToString());
        }

        #endregion
    }
}
