﻿namespace Platform.Uri
{
    public class NetUriPathSegmentParameter : NetUriParameter
    {
        #region Construction

        private const string _NameSet = @"-0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ._~!$&',:@()*+";
        private const string _ValueSet = @"-0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ._~!$&',=:@()*+";

        public NetUriPathSegmentParameter()
        {
        }

        internal NetUriPathSegmentParameter(string source)
            : base( source )
        {
        }

        public NetUriPathSegmentParameter(string name, string value)
            : base(name, value)
        {
        }

        #endregion

        #region properties

        protected override string NameSet
        {
            get { return _NameSet; }
        }

        protected override string ValueSet
        {
            get { return _ValueSet; }
        }

        protected override bool UseFormEncoding
        {
            get { return false; }
        }

        #endregion

        #region String Casts

        /// <summary>
        /// Convert from string
        /// </summary>
        /// <param name="source"></param>
        /// <returns></returns>
        public static implicit operator NetUriPathSegmentParameter(string source)
        {
            return new NetUriPathSegmentParameter(source);
        }

        /// <summary>
        /// Convert to string
        /// </summary>
        /// <param name="source"></param>
        /// <returns></returns>
        public static implicit operator string(NetUriPathSegmentParameter source)
        {
            if (source == null) return null;
            else return source.ToString();
        }

        #endregion
    }
}
