﻿
using Platform.Net;

namespace Platform.Uri
{

    public class NetUriPathSegmentParameters : NetUriParameters<NetUriPathSegmentParameter>
    {
        #region Construction & Fields

        public NetUriPathSegmentParameters()
        {
        }

        internal NetUriPathSegmentParameters(string source)
            : base( source )
        {
        }

        #endregion

        #region Properties

        /// <summary>
        /// Gets the list seperation type
        /// </summary>
        protected override NetListSeperationType Seperation { get { return NetListSeperationType.Prefixed; } }

        /// <summary>
        /// Get the seperator
        /// </summary>
        protected override char Seperator { get { return ';'; } }

        #endregion

        #region String Casts

        /// <summary>
        /// Convert from string
        /// </summary>
        /// <param name="source"></param>
        /// <returns></returns>
        public static implicit operator NetUriPathSegmentParameters(string source)
        {
            return new NetUriPathSegmentParameters(source);
        }

        /// <summary>
        /// Convert to string
        /// </summary>
        /// <param name="source"></param>
        /// <returns></returns>
        public static implicit operator string(NetUriPathSegmentParameters source)
        {
            if (source == null) return null;
            else return source.ToString();
        }

        #endregion

        #region Encode / Decode

        /// <summary>
        /// Create Parameter
        /// </summary>
        /// <param name="source"></param>
        /// <returns></returns>
        protected override NetUriPathSegmentParameter CreateListItem(NetStringReader reader)
        {
            return new NetUriPathSegmentParameter(reader.ReadAll());
        }

        /// <summary>
        /// Create Parameter
        /// </summary>
        /// <param name="name"></param>
        /// <param name="value"></param>
        /// <returns></returns>
        protected override NetUriPathSegmentParameter CreateParameter(string name, string value)
        {
            return new NetUriPathSegmentParameter(name, value);
        }

        #endregion
    }
}
