﻿
using Platform.Net;

namespace Platform.Uri
{
    public class NetUriQuerySegment : NetUriParameter
    {
        #region Construction & Fields

        private const string _NameSet = @"-0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ._~!$',:@()*+";
        private const string _ValueSet = @"-0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ._~!$',=:@()*+";
        private NetUriQuerySegmentParameters _Parameters;

        public NetUriQuerySegment()
        {
        }

        internal NetUriQuerySegment(string source)
            : base( source )
        {
        }

        public NetUriQuerySegment(string name, string value)
            : base( name, value )
        {
        }

        protected override void Initialize()
        {
            _Parameters = new NetUriQuerySegmentParameters();
        }

        #endregion

        #region properties

        protected override string NameSet
        {
            get { return _NameSet; }
        }

        protected override string ValueSet
        {
            get { return _ValueSet; }
        }

        protected override bool UseFormEncoding
        {
            get { return true; }
        }

        public NetUriQuerySegmentParameters Parameters
        {
            get { Decode(); return _Parameters; }
            set { Decode(); _Parameters = value; }
        }

        #endregion

        #region String Casts

        /// <summary>
        /// Convert from string
        /// </summary>
        /// <param name="source"></param>
        /// <returns></returns>
        public static implicit operator NetUriQuerySegment(string source)
        {
            return new NetUriQuerySegment(source);
        }

        /// <summary>
        /// Convert to string
        /// </summary>
        /// <param name="source"></param>
        /// <returns></returns>
        public static implicit operator string(NetUriQuerySegment source)
        {
            if (source == null) return null;
            else return source.ToString();
        }

        #endregion

        #region Encoding / Decoding

        /// <summary>
        /// Decode uri into parts
        /// </summary>
        protected override void OnDecode( NetStringReader reader )
        {
            // call base class to decode parameter 
            base.OnDecode(new NetStringReader(reader.ReadAllOrUntil(';')));

            // get parameters
            _Parameters = new NetUriQuerySegmentParameters( reader.ReadAll() );
        }

        /// <summary>
        /// Convert to Uri string
        /// </summary>
        /// <returns></returns>
        protected override void OnEncode( NetStringWriter writer )
        {
            // write parameter stuff
            base.OnEncode(writer);

            // write parmeter's parameters
            if (_Parameters != null) 
                writer.Write( _Parameters.ToString() );
        }

        #endregion
    }
}
