﻿namespace Platform.Uri
{
    /// <summary>
    /// A single Uri Segment Parameter
    /// </summary>
    public class NetUriQuerySegmentParameter : NetUriParameter
    {
        #region Construction

        private const string _NameSet = @"-0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ._~!$',:@()*+";
        private const string _ValueSet = @"-0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ._~!$',=:@()*+";

        public NetUriQuerySegmentParameter()
        {
        }

        internal NetUriQuerySegmentParameter(string source)
            : base( source )
        {
        }

        public NetUriQuerySegmentParameter(string name, string value)
            : base(name, value)
        {
        }

        #endregion

        #region properties

        protected override string NameSet
        {
            get { return _NameSet; }
        }

        protected override string ValueSet
        {
            get { return _ValueSet; }
        }

        protected override bool UseFormEncoding
        {
            get { return true; }
        }

        #endregion

        #region String Casts

        /// <summary>
        /// Convert from string
        /// </summary>
        /// <param name="source"></param>
        /// <returns></returns>
        public static implicit operator NetUriQuerySegmentParameter(string source)
        {
            return new NetUriQuerySegmentParameter(source);
        }

        /// <summary>
        /// Convert to string
        /// </summary>
        /// <param name="source"></param>
        /// <returns></returns>
        public static implicit operator string(NetUriQuerySegmentParameter source)
        {
            if (source == null) return null;
            else return source.ToString();
        }

        #endregion
    }
}
