﻿
using Platform.Net;

namespace Platform.Uri
{
    public class NetUriQuerySegmentParameters : NetUriParameters<NetUriQuerySegmentParameter>
    {
        #region Construction & Fields

        public NetUriQuerySegmentParameters()
        {
        }

        internal NetUriQuerySegmentParameters(string source)
            : base(source)
        {
        }

        #endregion

        #region Properties

        /// <summary>
        /// Gets the list seperation type
        /// </summary>
        protected override NetListSeperationType Seperation { get { return NetListSeperationType.Prefixed; } }

        /// <summary>
        /// Get the seperator
        /// </summary>
        protected override char Seperator { get { return ';'; } }

        #endregion

        #region String Casts

        /// <summary>
        /// Convert from string
        /// </summary>
        /// <param name="source"></param>
        /// <returns></returns>
        public static implicit operator NetUriQuerySegmentParameters(string source)
        {
            return new NetUriQuerySegmentParameters(source);
        }

        /// <summary>
        /// Convert to string
        /// </summary>
        /// <param name="source"></param>
        /// <returns></returns>
        public static implicit operator string(NetUriQuerySegmentParameters source)
        {
            if (source == null) return null;
            else return source.ToString();
        }

        #endregion

        #region Encode / Decode

        protected override NetUriQuerySegmentParameter CreateListItem(NetStringReader reader)
        {
            return new NetUriQuerySegmentParameter(reader.ReadAll());
        }

        protected override NetUriQuerySegmentParameter CreateParameter(string name, string value)
        {
            return new NetUriQuerySegmentParameter(name, value);
        }

        #endregion
    }
}
